% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dt_rows.R
\name{get_dt_rows}
\alias{get_dt_rows}
\title{Maps the \code{lengthMenu}selected value property of \code{DT::datatable} to a Shiny variable.}
\usage{
get_dt_rows(dt_name, dt_rows)
}
\arguments{
\item{dt_name}{\code{ns()} of \code{inputId} of the \code{DT::datatable}}

\item{dt_rows}{\code{ns()} of \code{inputId} of the variable that holds the current selected value of \code{lengthMenu}}
}
\value{
(\code{shiny::tagList}) A \code{shiny} tagList.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
library(shiny)
ui <- function(id) {
  ns <- NS(id)
  tagList(
    DT::DTOutput(ns("data_table")),
    get_dt_rows(ns("data_table"), ns("dt_rows"))
  )
}

# use the input$dt_rows in the Shiny Server function
server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$data_table <- DT::renderDataTable(
      {
        iris
      },
      options = list(pageLength = input$dt_rows)
    )
  })
}

if (interactive()) {
  shinyApp(
    ui = ui("my_table_module"),
    server = function(input, output, session) server("my_table_module")
  )
}
}
