% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tleaves.R
\name{.get_Tv}
\alias{.get_Tv}
\title{Calculate virtual temperature}
\usage{
.get_Tv(Temp, p, P, epsilon, unitless)
}
\arguments{
\item{Temp}{Temperature in Kelvin}

\item{p}{water vapour pressure in kPa}

\item{P}{Atmospheric pressure in kPa}

\item{epsilon}{ratio of water to air molar masses (unitless)}

\item{unitless}{Logical. Should function use parameters with \code{units}? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
Value in K of class \code{units}
}
\description{
Calculate virtual temperature
}
\details{
\deqn{T_\mathrm{v} = T / [1 - (1 - \epsilon) (p / P)]}{T_v = T / [1 - (1 - epsilon) (p / P)]}

Eq. 2.35 in Monteith & Unsworth (2013) \cr
\cr
\tabular{lllll}{
\emph{Symbol} \tab \emph{R} \tab \emph{Description} \tab \emph{Units} \tab \emph{Default}\cr
\eqn{\epsilon} \tab \code{epsilon} \tab ratio of water to air molar masses \tab unitless \tab 0.622 \cr
\eqn{p} \tab \code{p} \tab water vapour pressure \tab kPa \tab \link[=.get_ps]{calculated}\cr
\eqn{P} \tab \code{P} \tab atmospheric pressure \tab kPa \tab 101.3246
}
}
\examples{

library(tealeaves)

cs <- make_constants()
ep <- make_enviropar()
lp <- make_leafpar()

T_leaf <- set_units(298.15, K)
p <- ep$RH * tealeaves:::.get_ps(T_leaf, ep$P, FALSE)
tealeaves:::.get_Tv(T_leaf, p, ep$P, cs$epsilon, FALSE)

}
\references{
Monteith JL, Unsworth MH. 2013. Principles of Environmental Physics. 4th edition. Academic Press, London.
}
