% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\name{get_updates}
\alias{get_updates}
\title{get_updates}
\usage{
get_updates(offset = NULL, limit = 100, timeout = 0,
  allowed_updates = NULL)
}
\arguments{
\item{offset}{(Optional). Identifier of the first update to be returned
returned.}

\item{limit}{(Optional). Limits the number of updates to be retrieved. Values
between 1-100 are accepted. Defaults to 100.}

\item{timeout}{(Optional). Timeout in seconds for long polling. Defaults to 0,
i.e. usual short polling. Should be positive, short polling should
be used for testing purposes only.}

\item{allowed_updates}{(Optional). String or vector of strings with the types of
updates you want your bot to receive. For example, specify \code{c("message",
"edited_channel_post", "callback_query")} to only receive updates of these types. See
\href{https://core.telegram.org/bots/api#update}{Update}
for a complete list of available update types. Specify an empty string to receive all
updates regardless of type (default). If not specified, the previous setting will be used.

Please note that this parameter doesn't affect updates created before the call
to the get_updates, so unwanted updates may be received for a short period of time.}
}
\description{
Use this method to receive incoming updates using long polling.
}
\details{
1. This method will not work if an outgoing webhook is set up.

2. In order to avoid getting duplicate updates, recalculate offset after each
server response.

3. To take full advantage of this library take a look at \code{\link{Updater}}.
}
