% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tenFM.R
\name{tenFM.rank}
\alias{tenFM.rank}
\title{Rank Determination for Tensor Factor Models with Tucker Structure}
\usage{
tenFM.rank(x,r,h0=1,rank='IC',method='TIPUP',inputr=FALSE,iter=TRUE,penalty=1,
delta1=0,tol=1e-4,maxiter=100)
}
\arguments{
\item{x}{\eqn{T \times d_1 \times \cdots \times d_K} tensor-valued time series.}

\item{r}{initial guess of the rank of factor tensor.}

\item{h0}{the number of lags used in auto-covariance tensor.}

\item{rank}{character string, specifying the type of the rank determination method to be used. \describe{
 \item{\code{"IC",}}{information criterion.}
 \item{\code{"ER",}}{eigen ratio criterion.}
}}

\item{method}{character string, specifying the type of the factor estimation method to be used. \describe{
 \item{\code{"TIPUP",}}{TIPUP method.}
 \item{\code{"TOPUP",}}{TOPUP method.}
}}

\item{inputr}{boolean, if TRUE, always use initial guess rank r in each iteration; if FLASE, the rank will be updated in each iteration.}

\item{iter}{boolean, specifying using an iterative approach or a non-iterative approach.}

\item{penalty}{takes value in {1,2,3,4,5}, decides which penalty function to use for each tesnor mode \eqn{k}. Here \eqn{\nu} is a tuning parameter defined in the argument "\code{delta1}", and \eqn{d=\prod_{i=1}^{K} d_k }.
When \code{rank}= '\code{IC}':\cr
if \code{penalty}=1, \eqn{g_1= \frac{h_0 d^{2-2\nu}}{T}\log(\frac{dT}{d+T})};\cr
if \code{penalty}=2, \eqn{g_2= h_0 d^{2-2\nu}(\frac{1}{T}+\frac{1}{d})\log(\frac{dT}{d+T})};\cr
if \code{penalty}=3, \eqn{g_3= \frac{h_0 d^{2-2\nu}}{T} \log(\min{(d,T)})};\cr
if \code{penalty}=4, \eqn{g_4= h_0 d^{2-2\nu}(\frac{1}{T}+\frac{1}{d})\log(\min{(d,T)})};\cr
if \code{penalty}=5, \eqn{g_5= h_0 d^{2-2\nu}(\frac{1}{T}+\frac{1}{d})\log(\min{(d_k,T)})}.\cr
When \code{rank}= '\code{ER}':\cr
if \code{penalty}=1, \eqn{h_1= c_0 h_0};\cr
if \code{penalty}=2, \eqn{h_2= \frac{h_0 d^2}{T^2}};\cr
if \code{penalty}=3, \eqn{h_3= \frac{h_0 d^2}{T^2 d_k^2}};\cr
if \code{penalty}=4, \eqn{h_4= \frac{h_0 d^2}{T^2 d_k^2} + \frac{h_0 d_k^2}{T^2}};\cr
if \code{penalty}=5, \eqn{h_5= \frac{h_0 d^2}{T^2 d_k^2} + \frac{h_0 dd_k^2}{T^2}}.\cr}

\item{delta1}{weakest factor strength, a tuning parameter used for IC method only}

\item{tol}{tolerance in terms of the Frobenius norm.}

\item{maxiter}{maximum number of iterations if error stays above \code{tol}.}
}
\value{
return a list containing the following:\describe{
\item{\code{path}}{a \eqn{K \times (\rm{niter}+1)} matrix of the estimated Tucker rank of the factor process as a path of the maximum number of iteration (\eqn{\rm{niter}}) used. The first row is the estimated rank under non-iterative approach, the \eqn{i+1}-th row is the estimated rank \eqn{\hat r_1, \hat r_2, \cdots, \hat r_K} at \eqn{(i)}-th iteration.}
\item{\code{factor.num}}{final solution of the estimated Tucker rank of the factor process \eqn{\hat r_1, \hat r_2, \cdots, \hat r_K}.}
}
}
\description{
Function for rank determination of tensor factor models with Tucker Structure.
Two unfolding methods of the auto-covariance tensor, Time series Outer-Product Unfolding Procedure (TOPUP), Time series Inner-Product Unfolding Procedure (TIPUP),
are included, as determined by the value of \code{method}.
Different penalty functions for the information criterion (IC) and the eigen ratio criterion (ER) can be used,
which should be specified by the value of \code{rank} and \code{penalty}. The information criterion resembles BIC in the vector factor model literature.
And the eigen ratio criterion is similar to the eigenvalue ratio based methods in the vector factor model literature.
}
\details{
Let \eqn{W} be a \eqn{p\times p} symmetric and non-negative definite matrix and \eqn{\widehat{W}} be its sample version, \eqn{{\hat\lambda}_j} be the eigenvalues of \eqn{\widehat{W}}
such that \eqn{{\hat\lambda}_1\geq {\hat\lambda}_2 \geq \cdots \hat{\lambda}_p}.
The rank determination methods using the information criterion ("IC") and the eigen ratio criterion ("ER") are defined as follows:
\deqn{IC(\widehat{W}) = \mathrm{argmin}_{0\leq m \leq m^{*}} \left\{ \sum_{j=m+1}^{p} {\hat\lambda}_j + mg(\widehat{W}) \right\},}
\deqn{ER(\widehat{W}) = \mathrm{argmin}_{0\leq m \leq m^{*}} \left\{ \frac{{\hat\lambda}_{m+1}+h(\widehat{W})}{ {\hat\lambda}_m +h(\widehat{W})} \right\},}
where \eqn{m^{*}} is a predefined upper bound, \eqn{g} and \eqn{h} are some appropriate positive penalty functions. We have provided 5 choices for \eqn{g} and \eqn{h};
see more details in the argument "\code{penalty}".
For non-iterative TOPUP and TIPUP methods, \eqn{\widehat{W}} is
\eqn{ {\rm mat}_1({\rm{TOPUP}}_{k}(X_{1:T})) {\rm mat}_1({\rm{TOPUP}}_{k}(X_{1:T}))^\top } or
\eqn{ ({\rm{TIPUP}}_{k}(X_{1:T})) ({\rm{TIPUP}}_{k}(X_{1:T}))^\top }, for each tensor mode \eqn{k}, \eqn{1\leq k \leq K},
where \eqn{{\rm{TOPUP}}_{k}(X_{1:T})} and \eqn{{\rm{TIPUP}}_{k}(X_{1:T})} are defined in the Details section of the function \code{\link{tenFM.est}}.
For iterative TOPUP and TIPUP methods, we refer to the literature in the References section for more information.
}
\examples{
set.seed(333)
dims <- c(16,18,20) # dimensions of tensor time series
r <- c(3,3,3)  # dimensions of factor series
Ft <- tenAR.sim(t=100, dim=r, R=1, P=1, rho=0.9, cov='iid')
lambda <- sqrt(prod(dims))
x <- tenFM.sim(Ft,dims=dims,lambda=lambda,A=NULL,cov='iid') # generate t*dims tensor time series
rank <- tenFM.rank(x,r=c(4,4,4),h0=1,rank='IC',iter=TRUE,method='TIPUP')  # Estimate the rank
}
\references{
Han, Yuefeng, Cun-Hui Zhang, and Rong Chen. "Rank Determination in Tensor Factor Model." Available at SSRN 3730305 (2020).
}
