% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like_inference.R
\name{lrt_null_dist_dim_same}
\alias{lrt_null_dist_dim_same}
\title{Draw from null distribution of likelihood ratio test statistic.}
\usage{
lrt_null_dist_dim_same(p, null_ident = NULL, alt_ident = NULL,
  null_diag = NULL, alt_diag = NULL, reference_dist = "normal",
  t_df = NULL, itermax = 100, holq_itermax = 100, holq_tol = 10^-9)
}
\arguments{
\item{p}{A vector of integers. The dimensions of the array.}

\item{null_ident}{A vector of integers. The modes that under the null have
identity covariance.}

\item{alt_ident}{A vector of integers. The modes that under the alternative
have the identity covariance.}

\item{null_diag}{A vector of integers. The modes that under the null have
diagonal covariance.}

\item{alt_diag}{A vector of integers. The modes that under the alternative
have diagonal covariance.}

\item{reference_dist}{Two options are supported, 'normal' and 't'. If 't' is
specified, you have to specify \code{t_df}.}

\item{t_df}{A numeric. If \code{reference_dist} is 't', then this is the
degrees of freedom of the t_distribution that the array is distributed
under.}

\item{itermax}{An integer. The number of draws from the null distribution of
the likelihood ratio test statistic that is to be performed.}

\item{holq_itermax}{An integer. The maximum number of block coordinate ascent
iterations to perform when calculating the MLE at each step.}

\item{holq_tol}{A numeric. The stopping criterion when calculating the MLE.}
}
\value{
A vector of draws from the null distribution of the likelihood ratio
  test statistic.
}
\description{
When testing for the covariance structure of modes, this function may be used
to draw a sample from the null distribution of the likelihood ratio test
stistics, whose distribution doesn't depend on any unknown parameters under
the null.
}
\details{
Let \eqn{vec(X)} be \eqn{N(0,\Sigma)}. Given two nested hypotheses, \deqn{H_1:
\Sigma = \Psi_K\otimes\cdots\otimes\Psi_1} versus \deqn{H_0: \Sigma =
\Omega_K\otimes\cdots\otimes\Omega_1,} this function will draw from the null
distribution of the likelihood ratio test statistic. The possible options are
that \eqn{\Psi_i} or \eqn{\Omega_i} are the identity matrix, a diagonal
matrix, or any positive definite matrix. By default, it's assumed that these
matrices are any positive definite matrix.

Unfortunately, this fuction does not support testing for the hypothesis of
modeling the covariance between two modes with a single covariance matrix. I
might code this up in later versions.
}
\examples{
#Test for all identity versus all unconstrained.
p = c(4,4,4)
null1 <- lrt_null_dist_dim_same(p,null_ident = 1:3)

#Generate Null Data
X <- array(stats::rnorm(prod(p)), dim = p)
sig_null <- holq(X, mode_rep = 1:3)$sig
sig_alt <- holq(X)$sig
lrt_x <- lrt_stat(sig_null, sig_alt, p = p)
p_value <- mean(null1 > lrt_x)

hist(null1,main = 'Null Distribution of LRT', xlab = 'LRT Statistic')
abline(v = lrt_x, lty = 2, col = 2, lwd = 2)
legend('topleft', 'Observed LRT Statistic', lty = 2, col = 2, lwd = 2)
mtext(side = 1, paste('P-value = ', round(p_value, digits = 2), sep = ''),
      line = 2)

#-------------------------------------------------------------------------

#Test for all identity versus all mode 1 identity,
#  mode 2 diagonal, mode 3 unconstrained.
p = c(4,4,4)
null2 <- lrt_null_dist_dim_same(p,null_ident = 1:3,
                                alt_ident = 1, alt_diag = 2)

#Generate Null Data
X <- array(stats::rnorm(prod(p)), dim = p)
sig_null <- holq(X, mode_rep = 1:3)$sig
sig_alt <- holq(X, mode_rep = 1, mode_diag = 2)$sig
lrt_x <- lrt_stat(sig_null, sig_alt, p = p)
p_value <- mean(null2 > lrt_x)

hist(null2,main = 'Null Distribution of LRT', xlab = 'LRT Statistic')
abline(v = lrt_x, lty = 2, col = 2, lwd = 2)
legend('topleft', 'Observed LRT Statistic', lty = 2, col = 2, lwd = 2)
mtext(side = 1, paste('P-value = ', round(p_value, digits = 2), sep = ''),
      line = 2)
}
\author{
David Gerard.
}
\references{
Gerard, D. C., & Hoff, P. D. (2014).
  \href{http://arxiv.org/abs/1410.1094}{A higher-order LQ decomposition for
  separable covariance models}. \emph{arXiv preprint arXiv:1410.1094.}
}
\seealso{
\code{\link{lrt_stat}} for calculating the likelihood ratio test
  statistic.
}
\keyword{likelihood}

