% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.networks.R, R/print.combined_networks.R
\name{combine_networks}
\alias{combine_networks}
\alias{combined_networks}
\alias{print.combined_networks}
\alias{summary.combined_networks}
\alias{print.summary.combined_networks}
\title{A single block-diagonal network created by combining multiple networks}
\usage{
combine_networks(
  nwl,
  ignore.nattr = c("mnext"),
  ignore.vattr = c(),
  ignore.eattr = c(),
  blockID.vattr = ".NetworkID",
  blockName.vattr = NULL,
  detect.edgecov = FALSE,
  keep.unshared.attr = FALSE,
  subnet.cache = FALSE
)

\method{print}{combined_networks}(x, ...)

\method{summary}{combined_networks}(object, ...)

\method{print}{summary.combined_networks}(x, ...)
}
\arguments{
\item{nwl}{a list of \code{\link[network:network]{network::network}}s to be combined; they
must have similar fundamental properties: directedness and
bipartedness, though their sizes (and the size of each bipartite
group) can vary.}

\item{ignore.nattr, ignore.vattr, ignore.eattr}{network, vertex, and
edge attributes not to be processed as described below.}

\item{blockID.vattr}{name of the vertex attribute into which to store
the index of the network to which that vertex originally belonged.}

\item{blockName.vattr}{if not \code{NULL}, the name of the vertex
attribute into which to store the name of the network to which
that vertex originally belonged.}

\item{detect.edgecov}{if \code{TRUE}, combine network attributes that
look like dyadic covariate (\code{\link[ergm:edgecov-ergmTerm-1fb5ef19]{ergm::edgecov}}) matrices into a
block-diagonal matrix.}

\item{keep.unshared.attr}{whether to keep those network, vertex,
and edge attributes not shared by all networks in the list; if
\code{TRUE}, positions corresponding to networks lacking the
attribute are replaced with \code{NA}, \code{NULL}, or some other
placeholder; incompatible with \code{detect.edgecov==TRUE}.}

\item{subnet.cache}{whether to save the input network list as an
attribute of the combined network, so that if the network is
resplit using on the same attribute (e.g. using
\code{\link[=uncombine_network]{uncombine_network()}}), an expensive call to \code{\link[=split.network]{split.network()}}
can be avoided, at the cost of storage.}

\item{x, object}{a combined network.}

\item{...}{additional arguments to methods.}
}
\value{
an object of class \code{combined_networks} inheriting from
\code{\link[network:network]{network::network}} with a block-diagonal structure (or its
bipartite equivalent) comprising the networks passed in \code{nwl}. In
particular,
\itemize{
\item the returned network's size is the sum of the input networks';
\item its basic properties (directedness and bipartednes) are the same;
\item the input networks' sociomatrices (both edge presence and edge
attributes) are the blocks in the sociomatrix of the returned
network;
\item vertex attributes are concatenated;
\item edge attributes are assigned to their respective edges in
the returned network;
\item network attributes are stored in a list; but if
\code{detect.edgecov==TRUE}, those network attributes that have the
same dimension as the sociomatrices of the constituent networks,
they are combined into a single block-diagonal matrix that is
then stored as that attribute.
}

In addition, a two new vertex attibutes, specified by
\code{blockID.vattr} and (optionally) \code{blockName.vattr} contain,
respectively, the index in \code{nwl} of the network from which that
vertex came and its name, determined as follows:
\enumerate{
\item If \code{nwl} is a named list, names from the list are used.
\item If not 1, but the network has an attribute \code{title}, it is used.
\item Otherwise, a numerical index is used.
}

If \code{blockID.vattr} already exists on the constituent networks, the
index is \emph{prepended} to the attribute.
}
\description{
Given a list of compatible networks, the \code{\link[=combine_networks]{combine_networks()}} returns a single
block-diagonal network, preserving attributes that can be
preserved.
}
\section{Functions}{
\itemize{
\item \code{print(combined_networks)}: A wrapper around
\code{\link[network:network]{network::print.network()}} to print constituent network
information and omit some internal variables.

\item \code{summary(combined_networks)}: A wrapper around
\code{\link[network:network]{network::summary.network()}} to print constituent network
information and omit some internal variables.

\item \code{print(summary.combined_networks)}: A wrapper around
\code{\link[network:network]{network::print.summary.network()}} to print constituent network
information and omit some internal variables.

}}
\examples{

data(samplk)

o1 <- combine_networks(list(samplk1, samplk2, samplk3))
image(as.matrix(o1))
head(get.vertex.attribute(o1, ".NetworkID"))
o2 <- combine_networks(list(o1, o1))
image(as.matrix(o2))
head(get.vertex.attribute(o2, ".NetworkID", unlist=FALSE))

data(florentine)
f1 <- combine_networks(list(business=flobusiness, marriage=flomarriage),
                       blockName.vattr=".NetworkName")
image(as.matrix(f1))
head(get.vertex.attribute(f1, ".NetworkID"))
head(get.vertex.attribute(f1, ".NetworkName"))
}
