% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_to_raw_tiles.R
\name{raster_to_raw_tiles}
\alias{raster_to_raw_tiles}
\title{Crop a raster and convert the output tiles into new formats.}
\usage{
raster_to_raw_tiles(input_file, output_prefix, side_length = 4097, raw = TRUE)
}
\arguments{
\item{input_file}{File path to the input TIFF file to convert.}

\item{output_prefix}{The file path to prefix output tiles with.}

\item{side_length}{The side length, in pixels, for the .raw tiles.}

\item{raw}{Logical: Convert the cropped tiles to .raw? When \code{FALSE}
returns a .png.}
}
\value{
Invisibly, a character vector containing the file paths that were
written to.
}
\description{
This function has been deprecated as of terrainr 0.5.0 in favor of the new
function, [make_manifest]. While it will be continued to be exported until
at least 2022, improvements and bug fixes will only be made to the new
function. Please open an issue if any features you relied upon is
missing from the new function!
}
\details{
This function crops input raster files into smaller square tiles and then
converts them into either .png or .raw files which are ready to be imported
into the Unity game engine.
}
\examples{
\dontrun{
if (!isTRUE(as.logical(Sys.getenv("CI")))) {
  simulated_data <- data.frame(
    id = seq(1, 100, 1),
    lat = runif(100, 44.04905, 44.17609),
    lng = runif(100, -74.01188, -73.83493)
  )
  simulated_data <- sf::st_as_sf(simulated_data, coords = c("lng", "lat"))
  output_files <- get_tiles(simulated_data)
  temptiff <- tempfile(fileext = ".tif")
  merge_rasters(output_files["elevation"][[1]], temptiff)
  raster_to_raw_tiles(temptiff, tempfile())
}
}

}
\seealso{
Other data manipulation functions: 
\code{\link{combine_overlays}()},
\code{\link{georeference_overlay}()},
\code{\link{merge_rasters}()},
\code{\link{vector_to_overlay}()}

Other visualization functions: 
\code{\link{combine_overlays}()},
\code{\link{geom_spatial_rgb}()},
\code{\link{vector_to_overlay}()}
}
\concept{data manipulation functions}
\concept{visualization functions}
