% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{cellVolume}
\alias{cellVolume}
\title{Volume of a bounded Voronoï cell}
\usage{
cellVolume(cell)
}
\arguments{
\item{cell}{a bounded 2D or 3D Voronoï cell}
}
\value{
A number, the area/volume of the cell, and in the 3D case, the
  surface area of the cell is attached to this number as an attribute.
}
\description{
For a bounded 2D Voronoï cell, returns the area of the cell,
  and for a bounded 3D Voronoï cell, returns the volume of the cell and
  its surface area.
}
\examples{
library(tessellation)
d <- delaunay(centricCuboctahedron())
v <- voronoi(d)
cell13 <- v[[13]]
isBoundedCell(cell13) # TRUE
cellVolume(cell13)
}
