% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-files.R
\name{test_file}
\alias{test_file}
\title{Run all tests in a single file}
\usage{
test_file(path, reporter = default_compact_reporter(), package = NULL, ...)
}
\arguments{
\item{path}{Path to file.}

\item{reporter}{Reporter to use to summarise output. Can be supplied
as a string (e.g. "summary") or as an R6 object
(e.g. \code{SummaryReporter$new()}).

See \link{Reporter} for more details and a list of built-in reporters.}

\item{package}{If these tests belong to a package, the name of the package.}

\item{...}{Additional parameters passed on to \code{test_dir()}}
}
\value{
A list (invisibly) containing data about the test results.
}
\description{
A variant of \code{\link[=test_dir]{test_dir()}} that only tests a single file within a directory.
Helper, setup, and teardown files located in the same directory as the
test will also be run.
}
\section{Special files}{

There are two types of \code{.R} file that have special behaviour:
\itemize{
\item Test files start with \code{test} and are executed in alphabetical order.
\item Setup files start with \code{setup} and are executed before tests. If
clean up is needed after all tests have been run, you can use
\code{withr::defer(clean_up(), teardown_env())}. See \code{vignette("text-fixtures")}
for more details.
}

There are two other types of special file that we no longer recommend using:
\itemize{
\item Helper files start with \code{helper} and are executed before tests are
run. They're also loaded by \code{devtools::load_all()}, so there's no
real point to them and you should just put your helper code in \verb{R/}.
\item Teardown files start with \code{teardown} and are executed after the tests
are run. Now we recommend interleave setup and cleanup code in \verb{setup-}
files, making it easier to check that you automatically clean up every
mess that you make.
}

All other files are ignored by testthat.
}

\section{Environments}{

Each test is run in a clean environment to keep tests as isolated as
possible. For package tests, that environment that inherits from the
package's namespace environment, so that tests can access internal functions
and objects.
}

\examples{
path <- testthat_example("success")
test_file(path)
test_file(path, reporter = "minimal")
}
