% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automation-tools.R
\name{latex_to_web}
\alias{latex_to_web}
\title{latex to web}
\usage{
latex_to_web(
  dir,
  log_steps = TRUE,
  example = FALSE,
  auto_wrapper = TRUE,
  temp_mode = TRUE,
  web_dir = FALSE,
  interactive_mode = FALSE,
  compile_rmd_in_temp = !temp_mode
)
}
\arguments{
\item{dir}{directory path}

\item{log_steps}{Enable/Disable Logging of conversion steps}

\item{example}{for examples only by default keep it FALSE.}

\item{auto_wrapper}{automatically creates a wrapper if TRUE, else asks user. default value TRUE}

\item{temp_mode}{temp mode will convert the document in a temporary folder and keep the original
article untouched. default value = TRUE}

\item{web_dir}{option to create a new web directory, default FALSE}

\item{interactive_mode}{interactive mode for converting articles with options. default FALSE}

\item{compile_rmd_in_temp}{This works only with a forked version of rjtools.
Not recommended to use with CRAN or github version of the rjtools package. (default FALSE)}
}
\value{
RJweb article document in /web folder
}
\description{
automated function for converting a single RJarticle to web
}
\note{
Use pandoc version greater than or equal to 2.17

Do not use example = TRUE param when working with conversions.
}
\examples{
# Checking for pandoc version
# texor works with pandoc version >= 2.17
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
texor::latex_to_web(your_article_path,log_steps = FALSE, example = TRUE, temp_mode =FALSE)
unlink(your_article_folder, recursive = TRUE)
}
