% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/untokenize.R
\name{step_untokenize}
\alias{step_untokenize}
\title{Untokenization of Token Variables}
\usage{
step_untokenize(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  sep = " ",
  skip = FALSE,
  id = rand_id("untokenize")
)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{sep}{a character to determine how the tokens should be separated when
pasted together. Defaults to \code{" "}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_untokenize} creates a \emph{specification} of a recipe step that will
convert a \code{\link[=tokenlist]{token}} variable into a character predictor.
}
\details{
This steps will turn a \code{\link[=tokenlist]{token}} vector back into a character
vector. This step is calling \code{paste} internally to put the tokens back
together to a character.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected) and \code{value} (seperator used for
collapsing).
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
library(recipes)
library(modeldata)
data(tate_text)

tate_rec <- recipe(~., data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  step_untokenize(medium)

tate_obj <- tate_rec \%>\%
  prep()

bake(tate_obj, new_data = NULL, medium) \%>\%
  slice(1:2)

bake(tate_obj, new_data = NULL) \%>\%
  slice(2) \%>\%
  pull(medium)

tidy(tate_rec, number = 2)
tidy(tate_obj, number = 2)
}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn characters into \code{\link[=tokenlist]{tokens}}
}
\concept{Steps for Un-Tokenization}
