% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsample.R
\name{downsample_matrix}
\alias{downsample_matrix}
\title{Downsample the columns of a matrix to a target number}
\usage{
downsample_matrix(
  mat,
  target_n = NULL,
  target_q = NULL,
  seed = NULL,
  remove_columns = FALSE
)
}
\arguments{
\item{mat}{An integer matrix to be downsampled. Can be a matrix or sparse matrix (dgCMatrix).
If the matrix contains NAs, the function will run significantly slower. Values that are
not integers will be coerced to integers using \code{floor()}.}

\item{target_n}{The target number of samples to downsample to.}

\item{target_q}{A target quantile of sums to downsample to. Only one of 'target_n' or 'target_q' can be provided.}

\item{seed}{The random seed for reproducibility (default is NULL)}

\item{remove_columns}{Logical indicating whether to remove columns with small sums (default is FALSE)}
}
\value{
The downsampled matrix
}
\description{
This function takes a matrix and downsamples it to a target number of samples.
It uses a random seed for reproducibility and allows for removing columns with
small sums.
}
\examples{
\dontshow{
# this line is only for CRAN checks
tglkmeans.set_parallel(1)
}

mat <- matrix(1:12, nrow = 4)
downsample_matrix(mat, 2)

# Remove columns with small sums
downsample_matrix(mat, 12, remove_columns = TRUE)

# sparse matrix
mat_sparse <- Matrix::Matrix(mat, sparse = TRUE)
downsample_matrix(mat_sparse, 2)

# with a quantile
downsample_matrix(mat, target_q = 0.5)

}
