% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.R
\name{as_tibble}
\alias{as_tibble}
\alias{as_tibble.tbl_df}
\alias{as_tibble.data.frame}
\alias{as_tibble.list}
\alias{as_tibble.matrix}
\alias{as_tibble.table}
\alias{as_tibble.NULL}
\alias{as_tibble.default}
\alias{as.tibble}
\alias{as_data_frame}
\title{Coerce lists and matrices to data frames.}
\usage{
as_tibble(x, ...)

\method{as_tibble}{tbl_df}(x, ...)

\method{as_tibble}{data.frame}(x, validate = TRUE, ...)

\method{as_tibble}{list}(x, validate = TRUE, ...)

\method{as_tibble}{matrix}(x, ...)

\method{as_tibble}{table}(x, n = "n", ...)

\method{as_tibble}{NULL}(x, ...)

\method{as_tibble}{default}(x, ...)
}
\arguments{
\item{x}{A list. Each element of the list must have the same length.}

\item{...}{Other arguments passed on to individual methods.}

\item{validate}{When \code{TRUE}, verifies that the input is a valid data
frame (i.e. all columns are named, and are 1d vectors or lists). You may
want to suppress this when you know that you already have a valid data
frame and you want to save some time.}

\item{n}{Name for count column, default: \code{"n"}.}
}
\description{
\code{\link[=as.data.frame]{as.data.frame()}} is effectively a thin wrapper around \code{data.frame},
and hence is rather slow (because it calls \code{\link[=data.frame]{data.frame()}} on each element
before \link{cbind}ing together). \code{as_tibble} is a new S3 generic
with more efficient methods for matrices and data frames.
}
\details{
This is an S3 generic. tibble includes methods for data frames (adds tbl_df
classes), tibbles (returns unchanged input), lists, matrices, and tables.
Other types are first coerced via \code{as.data.frame()} with
\code{stringsAsFactors = FALSE}.

\code{as_data_frame} and \code{as.tibble} are aliases.
}
\examples{
l <- list(x = 1:500, y = runif(500), z = 500:1)
df <- as_tibble(l)

m <- matrix(rnorm(50), ncol = 5)
colnames(m) <- c("a", "b", "c", "d", "e")
df <- as_tibble(m)

# as_tibble is considerably simpler than as.data.frame
# making it more suitable for use when you have things that are
# lists
\dontrun{
if (requireNamespace("microbenchmark", quiet = TRUE)) {
  l2 <- replicate(26, sample(letters), simplify = FALSE)
  names(l2) <- letters
  microbenchmark::microbenchmark(
    as_tibble(l2, validate = FALSE),
    as_tibble(l2),
    as.data.frame(l2)
  )
}

if (requireNamespace("microbenchmark", quiet = TRUE)) {
  m <- matrix(runif(26 * 100), ncol = 26)
  colnames(m) <- letters
  microbenchmark::microbenchmark(
    as_tibble(m),
    as.data.frame(m)
  )
}
}
}
