% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results-table_results.R
\name{table_cors}
\alias{table_cors}
\title{Extract correlation tables}
\usage{
table_cors(x, value_column = "est_sig_std", digits = 2, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{value_column}{Character. Name of the column to use to propagate the
matrix. Defaults to "est_sig_std", the standardized estimate with
significance asterisks.}

\item{digits}{Number of digits to round to when formatting values.}

\item{...}{Additional arguments passed to and from methods.}
}
\value{
A Matrix or a list of matrices (in case there are between/within
correlation matrices).
}
\description{
Extracts a publication-ready covariance or correlation matrix from an object
for which a method exists.
}
\examples{
library(lavaan)
HS.model <- '  visual =~ x1 + x2 + x3
               textual =~ x4 + x5 + x6
               speed   =~ x7 + x8 + x9 '
fit <- cfa(HS.model,
           data = HolzingerSwineford1939,
           group = "school")
table_cors(fit)
}
\author{
Caspar J. van Lissa
}
