% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture-3step.R
\name{lr_test}
\alias{lr_test}
\title{Conduct Likelihood Ratio tests}
\usage{
lr_test(x, compare = c("All", "A", "S", "F", "M", "Thresholds"), ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{compare}{Character vector, indicating which matrices to constrain to be
equal in pairwise comparisons.}

\item{...}{Additional arguments passed to other functions.}
}
\value{
An object of class \code{lr_test} and \code{list}.
}
\description{
For a multigroup model of class \code{MxModel},
conduct overall and pairwise likelihood ratio tests.
All submodels must be identical.
}
\examples{
if(requireNamespace("OpenMx", quietly = TRUE)){
df <- iris[c(1:10, 140:150), c(1, 5)]
names(df) <- c("x", "group")
mod <- as_ram("x~1", data = df, group = "group")
mod <- run_mx(mod)
lr_test(mod)
}
}
