% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_mixture.R
\name{mx_lca}
\alias{mx_lca}
\title{Estimate latent class analyses using OpenMx}
\usage{
mx_lca(data = NULL, classes = 1L, run = TRUE, ...)
}
\arguments{
\item{data}{The data.frame to be used for model fitting.}

\item{classes}{A vector of integers, indicating which class solutions to
generate. Defaults to 1L. E.g., \code{classes = 1:6},}

\item{run}{Logical, whether or not to run the model. If \code{run = TRUE},
the function calls \code{\link[OpenMx:mxTryHardOrdinal]{OpenMx::mxTryHardOrdinal()}}.}

\item{...}{Additional arguments, passed to functions.}
}
\value{
Returns an \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}.
}
\description{
This function simplifies the specification of latent class models:
models that estimate membership of a categorical latent variable based on
binary or ordinal indicators.
}
\examples{
\dontrun{
df <- data_mix_ordinal
df[1:4] <- lapply(df, ordered)
mx_lca(data = df,
       classes = 2) -> res
}
}
\references{
Van Lissa, C. J., Garnier-Villarreal, M., & Anadria, D. (2023).
Recommended Practices in Latent Class Analysis using the Open-Source
R-Package tidySEM. Structural Equation Modeling.
\doi{10.1080/10705511.2023.2250920}
}
\keyword{mixture}
\keyword{models}
\keyword{openmx}
