% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_mixture.R
\name{mx_mixture}
\alias{mx_mixture}
\title{Estimate mixture models using OpenMx}
\usage{
mx_mixture(model, classes = 1L, data = NULL, run = TRUE, ...)
}
\arguments{
\item{model}{Syntax for the model; either a character string, or a list of
character strings, or a list of \code{mxModel} objects. See Details.}

\item{classes}{A vector of integers, indicating which class solutions to
generate. Defaults to 1L. E.g., \code{classes = 1:6},
\code{classes = c(1:4, 6:8)}.}

\item{data}{The data.frame to be used for model fitting.}

\item{run}{Logical, whether or not to run the model. If \code{run = TRUE},
the function calls \code{\link{mixture_starts}} and \code{\link{run_mx}}.}

\item{...}{Additional arguments, passed to functions.}
}
\value{
Returns an \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}.
}
\description{
Dynamically creates a batch of mixture models, with intelligent
defaults. See Details for more information.
}
\details{
Model syntax can be specified in three ways, for ease of use and
flexibility:
\enumerate{
\item An atomic character string with lavaan syntax. Within this syntax,
the character string \code{\{C\}} is dynamically substituted with the
correct class number using \code{\link{lsub}}, for example to set unique
parameter labels for each class, or to specify equality constraints. E.g.,
\code{x ~ m\{C\}*1} will be expanded to \code{x ~ m1*1} and \code{x ~ m2*1}
when \code{classes = 2}. The resulting syntax for each class will be
converted to an \code{mxModel} using \code{\link{as_ram}}.
\item A list of character strings with lavaan syntax. Each item of the list
will be converted to a class-specific \code{mxModel} using
\code{\link{as_ram}}.
\item A list of \code{mxModel} objects, specified by the user.
}
}
\examples{
\dontrun{
# Example 1: Dynamic model generation using {C}
df <- iris[, 1, drop = FALSE]
names(df) <- "x"
mx_mixture(model = "x ~ m{C}*1
                    x ~~ v{C}*x", classes = 1, data = df)
# Example 2: Manually specified class-specific models
df <- iris[1:2]
names(df) <- c("x", "y")
mx_mixture(model = list("y ~ a*x",
                        "y ~ b*x"),
                        meanstructure = TRUE,
                        data = df) -> res

# Example 3: Latent growth model
df <- empathy[1:6]
mx_mixture(model = "i =~ 1*ec1 + 1*ec2 + 1*ec3 +1*ec4 +1*ec5 +1*ec6
                    s =~ 0*ec1 + 1*ec2 + 2*ec3 +3*ec4 +4*ec5 +5*ec6",
                    classes = 2,
                    data = df) -> res
}
}
\references{
Van Lissa, C. J., Garnier-Villarreal, M., & Anadria, D. (2023).
Recommended Practices in Latent Class Analysis using the Open-Source
R-Package tidySEM. Structural Equation Modeling.
\doi{10.1080/10705511.2023.2250920}
}
\keyword{mixture}
\keyword{models}
\keyword{openmx}
