% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_census_api_call.R
\name{check_census_api_call}
\alias{check_census_api_call}
\title{A helper function to help parse API calls from the census}
\usage{
check_census_api_call(call)
}
\arguments{
\item{call}{a returned call from the US Census API}
}
\description{
A helper function to help parse API calls from the census
}
\examples{
\donttest{
library(tidyqwi)
library(httr)
# A single call to the API without an API Key
url <- "api.census.gov/data/timeseries/qwi/sa?get=Emp&for=county:198&key=NOKEY"
single_call <- httr::GET(url)

# Because a non valid API key was specified an message will be returned

check_census_api_call(single_call)

}

}
