% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_qwi.R
\name{get_qwi}
\alias{get_qwi}
\title{get_qwi}
\usage{
get_qwi(years, variables = NULL, quarters = c(1, 2, 3, 4),
  industry_level = 2, states, endpoint = "sa", all_groups = TRUE,
  owner_code = TRUE, geography = "cbsa", seasonadj = "U",
  apikey = NULL, processing = "sequential")
}
\arguments{
\item{years}{years to fetch (e.g. 2010, or c(2010, 2011))}

\item{variables}{the variables you wish to fetch. Default is all.}

\item{quarters}{The quarters to fetch (e.g. c(1,2,3,4)) Default is all}

\item{industry_level}{Industries to fetch. Default is all level 2}

\item{states}{state fips code to fetch}

\item{endpoint}{US Census endpoint designation. One of "sa" for Sex * Age, "se" for Sex by Education and "rh" for Race/Ethnicity}

\item{all_groups}{default to true}

\item{owner_code}{firm owner code}

\item{geography}{the US Census geography granuality (one of cbsa or county)}

\item{seasonadj}{seasonal adjustment factor (one of "U" or "S")}

\item{apikey}{your US Census API Key}

\item{processing}{the processing strategy (default = "sequential")}
}
\value{
the desired data from the US Census's Quaterly Workforce API
}
\description{
The purpose of this function is to retrive firm information from the
   US Census' Quarterly Workforce Indicator API. These data can be retrieved with by
   specifying the states, the quarters, the years, and additional detail. This function can
   accept multiple states, years and quarters. This makes the data retrieval easier and stay
   inside of the US Census' limits on the API.
}
\examples{
\dontrun{
library(tidyqwi)

# One state, one year
nc_qwi <- get_qwi(years = "2010",
               states = "11",
               geography = "county",
               apikey =  census_key,
               endpoint = "rh",
               variables = c("sEmp", "Emp"), all_groups = FALSE,
               industry_level = "2", processing = "sequential")

# Multiple states. multiple years
qwi_multi_year <- get_qwi(years = c("2010", "2011", "2012"),
               states = c("NC", "SC"),
               geography = "county",
               apikey =  census_key,
               endpoint = "rh",
               variables = c("sEmp", "Emp"), all_groups = FALSE,
               industry_level = "2", processing = "sequential")
}

}
