% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment-effects-bartCause.R
\name{treatment_effects.bartcFit}
\alias{treatment_effects.bartcFit}
\title{Get (individual) treatment effect draws from bartcFit posterior}
\usage{
\method{treatment_effects}{bartcFit}(
  model,
  treatment = NULL,
  newdata = NULL,
  subset = "all",
  common_support_method,
  cutoff,
  ...
)
}
\arguments{
\item{model}{A supported Bayesian model fit that can provide fits and predictions.}

\item{treatment}{Not used. Treatment variable specified by \code{bartcFit} object.}

\item{newdata}{Not used. extracts treatment effects already calculated by \code{bartcFit} object.}

\item{subset}{Either "treated", "nontreated", or "all". Default is "all".}

\item{common_support_method}{Either "sd", or "chisq". Default is unspecified, and no common support calculation is done.}

\item{cutoff}{Cutoff for common support (if in use).}

\item{...}{Arguments to be passed to \code{tidybayes::fitted_draws} typically scale for \code{BART} models.}
}
\value{
A tidy data frame (tibble) with treatment effect values.
}
\description{
CTE = Conditional Treatment Effects (usually used to generate (C)ATE or ATT)
\code{newdata} specifies the conditions, if unspecified it defaults to the original data.
Assumes treated column is either a integer column of 1's (treated) and 0's (nontreated) or logical indicating treatment if TRUE.
}
