% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tidyvpcobj}
\alias{plot.tidyvpcobj}
\title{plot}
\usage{
\method{plot}{tidyvpcobj}(
  x,
  ...,
  show.points = TRUE,
  show.boundaries = TRUE,
  show.stats = !is.null(x$stats),
  show.binning = isFALSE(show.stats),
  xlab = NULL,
  ylab = NULL,
  color = c("red", "blue", "red"),
  linetype = c("dotted", "solid", "dashed"),
  legend.position = "top",
  facet.scales = "free",
  custom.theme = "ggplot2::theme_bw"
)
}
\arguments{
\item{x}{A tidyvpcobj object.}

\item{...}{Further arguments can be specified but are ignored.}

\item{show.points}{Should the observed data points be plotted?}

\item{show.boundaries}{Should the bin boundary be displayed?}

\item{show.stats}{Should the VPC stats be displayed?}

\item{show.binning}{Should the binning be displayed by coloring the observed data points by bin?}

\item{xlab}{A character label for the x-axis.}

\item{ylab}{A character label for the y-axis.}

\item{color}{A character vector of colors for the percentiles, from low to high.}

\item{linetype}{A character vector of linetyps for the percentiles, from low to high.}

\item{legend.position}{A character string specifying the position of the legend.}

\item{facet.scales}{A character string specifying the `scales` argument to use for facetting.}

\item{custom.theme}{A Character string specifying theme from ggplot2 package}
}
\value{
A `ggplot` object.
}
\description{
Plot a \code{tidyvpcobj}.
}
\details{
Use ggplot2 graphics to plot and customize the appearance of VPC
}
\seealso{
\code{ggplot}
}
