% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metro_areas.R
\name{urban_areas}
\alias{urban_areas}
\title{Download an urban areas shapefile into R}
\usage{
urban_areas(cb = FALSE, year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Urban areas include both "urbanized areas," which are densely developed areas with a population of at least 50,000,
 and "urban clusters," which have a population of greater than 2,500 but less than 50,000.  For more information,
please see the link provided.
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2015/TGRSHP2015_TechDoc.pdf}

Other metro area functions: \code{\link{combined_statistical_areas}},
  \code{\link{core_based_statistical_areas}},
  \code{\link{metro_divisions}}, \code{\link{new_england}}
}

