#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  ../../COPYING


################################################################################
# METHOD:                   SUBSETTING METHODS ON DATA:
#  head,timeSeries           Returns the head of a 'timeSeries' object
################################################################################

setMethod("head", "timeSeries",
    function(x, n = 6, recordIDs = FALSE, ...)
{   # A function implemented by Diethelm Wuertz

    # Description:
    #   Returns the head of a 'timeSeries' object

    # Arguments:
    #   x - a 'timeSeries' object.

    # Value:
    #   Returns the head of an object of class 'timeSeries'.

    # FUNCTION:

    # Head:
    if (recordIDs & dim(x)[1] == dim(x@recordIDs)[1])
        cbind(head.matrix(x, n = n, ...), head(x@recordIDs, n = n, ...))
    else
        head.matrix(x, n = n, ...)
})
