% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_which.R
\name{cpp_which}
\alias{cpp_which}
\title{Efficient alternative to \code{which()}}
\usage{
cpp_which(x, invert = FALSE)
}
\arguments{
\item{x}{A \link{logical} vector.}

\item{invert}{If \code{TRUE}, indices of values that are not \code{TRUE} are returned
(including \code{NA}). If \code{FALSE} (the default), only \code{TRUE} indices are returned.}
}
\value{
An unnamed integer vector.
}
\description{
Exactly the same as \code{which()} but more memory efficient.
}
\details{
This implementation is similar in speed to \code{which()}
but usually more memory efficient.
}
\examples{
library(timeplyr)
library(bench)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
x <- sample(c(TRUE, FALSE), 1e05, TRUE)
x[sample.int(1e05, round(1e05/3))] <- NA

mark(cpp_which(TRUE), which(TRUE))
mark(cpp_which(FALSE), which(FALSE))
mark(cpp_which(logical()), which(logical()))
mark(cpp_which(x), which(x), iterations = 20)
mark(base = which(is.na(match(x, TRUE))),
     collapse = collapse::whichNA(collapse::fmatch(x, TRUE, overid = 2L)),
     timeplyr = cpp_which(x, invert = TRUE),
     iterations = 20)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}

}
