% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso_week.R
\name{iso_week}
\alias{iso_week}
\alias{isoday}
\title{Efficient, simple and flexible ISO week calculation}
\usage{
iso_week(x, year = TRUE, day = FALSE)

isoday(x)
}
\arguments{
\item{x}{Date vector.}

\item{year}{Logical. If \code{TRUE} then ISO Year is returned
along with the ISO week.}

\item{day}{Logical. If \code{TRUE} then day of the week is returned
with the ISO week, starting at 1, Monday, and ending at 7, Sunday.}
}
\value{
An ISO week vector of class \code{character}.
}
\description{
\code{iso_week()} is a flexible function to return formatted
ISO weeks, with optional ISO year and ISO day.
\code{isoday()} returns the day of the ISO week.
}
\examples{
library(timeplyr)
library(lubridate)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
iso_week(today())
iso_week(today(), day = TRUE)
iso_week(today(), year = FALSE, day = TRUE)
iso_week(today(), year = FALSE, day = FALSE)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
