% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-tk_augment_lags.R
\name{tk_augment_lags}
\alias{tk_augment_lags}
\alias{tk_augment_leads}
\title{Add many lags to the data}
\usage{
tk_augment_lags(.data, .value, .lags = 1, .names = "auto")

tk_augment_leads(.data, .value, .lags = -1, .names = "auto")
}
\arguments{
\item{.data}{A tibble.}

\item{.value}{One or more column(s) to have a transformation applied. Usage
of \code{tidyselect} functions (e.g. \code{contains()}) can be used to select multiple columns.}

\item{.lags}{One or more lags for the difference(s)}

\item{.names}{A vector of names for the new columns. Must be of same length as \code{.lags}.}
}
\value{
Returns a \code{tibble} object describing the timeseries.
}
\description{
A handy function for adding multiple lagged columns to a data frame.
Works with \code{dplyr} groups too.
}
\details{
\strong{Lags vs Leads}

A \emph{negative lag} is considered a lead. The \code{tk_augment_leads()} function is
identical to \code{tk_augment_lags()} with the exception that the
automatic naming convetion (\code{.names = 'auto'}) will convert column names with negative lags to
leads.

\strong{Benefits}

This is a scalable function that is:
\itemize{
\item Designed to work with grouped data using \code{dplyr::group_by()}
\item Add multiple lags by adding a sequence of lags using
the \code{.lags} argument (e.g. \code{.lags = 1:20})
}
}
\examples{
library(dplyr)
library(timetk)

# Lags
m4_monthly \%>\%
    group_by(id) \%>\%
    tk_augment_lags(contains("value"), .lags = 1:20)

# Leads
m4_monthly \%>\%
    group_by(id) \%>\%
    tk_augment_leads(value, .lags = 1:-20)

}
\seealso{
Augment Operations:
\itemize{
\item \code{\link[=tk_augment_timeseries_signature]{tk_augment_timeseries_signature()}} - Group-wise augmentation of timestamp features
\item \code{\link[=tk_augment_holiday_signature]{tk_augment_holiday_signature()}} - Group-wise augmentation of holiday features
\item \code{\link[=tk_augment_slidify]{tk_augment_slidify()}} - Group-wise augmentation of rolling functions
\item \code{\link[=tk_augment_lags]{tk_augment_lags()}} - Group-wise augmentation of lagged data
\item \code{\link[=tk_augment_differences]{tk_augment_differences()}} - Group-wise augmentation of differenced data
\item \code{\link[=tk_augment_fourier]{tk_augment_fourier()}} - Group-wise augmentation of fourier series
}

Underlying Function:
\itemize{
\item \code{\link[=lag_vec]{lag_vec()}} - Underlying function that powers \code{tk_augment_lags()}
}
}
