% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tind.R
\name{tind}
\alias{tind}
\alias{is.tind}
\title{A Common Representation of Time Indices of Different Types}
\usage{
tind(..., length = 0L, type = NULL, tz = NULL)

is.tind(x)
}
\arguments{
\item{...}{components of time index to be constructed (in arbitrary order),
the following are accepted:
\describe{
     \item{y}{year.}
     \item{q}{quarter.}
     \item{m}{month.}
     \item{w}{week (ISO 8601).}
     \item{d}{day.}
     \item{j}{day of year.}
     \item{u}{day of week (ISO 8601).}
     \item{H}{hour.}
     \item{M}{minute.}
     \item{S}{second.}
}}

\item{length}{an integer value specifying the desired length.}

\item{type}{a character value determining time index type
(\code{y} - years, \code{q} - quarters, \code{m} - months,
\code{w} - weeks, \code{d} - dates, \code{t} - date-time,
\code{h} - time of day,
\code{n} - numeric value, \code{i} - integer value).}

\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}

\item{x}{any R object.}
}
\value{
An object of \code{tind} class for \code{tind} or a logical
value for \code{is.tind}.
}
\description{
\code{tind} is an S3 class representing time indices of different
types (years, quarters, months, ISO 8601 weeks, dates, date-time,
and arbitrary integer/numeric indices). Time indices are represented
by vectors of integers or doubles with type attribute and
time zone attribute (date-time only). Objects of \code{tind} behave like plain
vectors and can be easily used in data frames.

A \code{tind} object would usually be created using \code{\link{as.tind}}
method or using \code{\link{parse_t}} and \code{\link{strptind}} functions.
\code{tind} constructor allows to create time indices from components
(like year, month, day) and to create vectors of a given length
filled with \code{NA} values.

\code{is.tind} function checks whether an object is of \code{tind} class.
}
\details{
\code{tind} class supports the following types of time indices:
\describe{
    \item{years}{internal code \code{"y"}.}
    \item{quarters}{internal code \code{"q"}.}
    \item{months}{internal code \code{"m"}.}
    \item{weeks}{internal code \code{"w"}.}
    \item{dates}{internal code \code{"d"}.}
    \item{date-time}{internal code \code{"t"}.}
    \item{time of day}{internal code \code{"h"}.}
    \item{arbitrary integer index}{\code{"i"}.}
    \item{arbitrary numeric index}{\code{"n"}.}
}

Valid ranges for time indices are:
\describe{
     \item{years (\code{"y"})}{\code{0000}--\code{9999}.}
     \item{quarters (\code{"q"})}{\code{0000q1}--\code{9999q4}.}
     \item{months (\code{"m"})}{\code{0000-01}--\code{9999-12}.}
     \item{weeks (\code{"w"})}{\code{0000-W01}--\code{9999-W52}.}
     \item{dates (\code{"d"})}{\code{0000-01-01}--\code{9999-12-31}.}
     \item{date-time (\code{"t"})}{from \code{0000-01-01 15:00:00Z} to \code{9999-12-31 09:00:00Z}
                 (between \code{-62167165200} and \code{253402246800}
                 seconds since the Unix epoch).}
     \item{time of day (\code{"h"})}{from \code{00:00} to \code{24:00}
                 (between \code{0} and \code{86400} seconds since midnight).}
}
}
\examples{
# years
tind(y = 2010:2020)
tind(type = "y")
tind(length = 11, type = "y")

# quarters
tind(y = rep(2020:2023, each = 4), q = 1:4)
tind(q = 1:4, y = rep(2020:2023, each = 4))
tind(type = "q")
tind(length = 4, type = "q")

# months
tind(y = 2023, m = 1:12)
tind(m = 1:12, y = 2023)
tind(type = "m")
tind(length = 12, type = "m")

# weeks
tind(y = 2024, w = 1 + 2 * (0:25))
tind(type = "w")
tind(length = 13, type = "w")

# dates
tind(m = 3, d = 15, y = 2024)
tind(y = 2024, m = rep(1:3, each = 2), d = c(1, 15))
tind(type = "d")
tind(length = 6, type = "d")

# time of day
tind(H = 16, M = (0:3) * 15)
tind(type = "h")
tind(length = 4, type = "h")

# date-time
# system time zone
tind(y = 2024, m = 8, d = 2, H = 16, M = (0:3) * 15)
tind(y = 2024, m = 8, d = 2, H = 16, M = (0:3) * 15)
tind(y = 2024, m = 8, d = 2, H = 16, M = 0, S = 10 * (0:5))
# time zone explicitly provided
tind(y = 2024, m = 8, d = 2, H = 16, M = (0:3) * 15, tz = "UTC")
tind(type = "t")
tind(type = "t", tz = "UTC")
tind(length = 4, type = "t")
tind(length = 4, type = "t", tz = "UTC")

# integer and numeric indices
# (cannot be constructed from components like above)
tind(length = 10, type = "i")
tind(length = 10, type = "n")

}
\seealso{
\code{\link{as.tind}} for conversion to \code{tind},
\code{\link{parse_t}} and \code{\link{strptind}} functions for
parsing character strings, \code{\link{date_time}} for construction
of date-time indices from date and time components, \link{tind-methods}
for basic methods.
}
