% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_snapshot_plot.R
\name{expect_equivalent_images}
\alias{expect_equivalent_images}
\title{Test if two image files are equivalent}
\usage{
expect_equivalent_images(
  current,
  target,
  tol = getOption("tinysnapshot_tol", default = 0),
  metric = getOption("tinysnapshot_metric", default = "AE"),
  fuzz = getOption("tinysnapshot_fuzz", default = 0),
  diffpath = NULL
)
}
\arguments{
\item{current}{path to an image file}

\item{target}{path to an image file}

\item{tol}{distance estimates larger than this threshold will trigger a test failure. Scale depends on the \code{metric} argument. With the default \code{metric="AE"} (absolute error), the \code{tolerance} corresponds roughly to the number of pixels of difference between the plot and the reference image.}

\item{metric}{string with a metric from \code{magick::metric_types()} such as \code{"AE"} or \code{"phash"}.}

\item{fuzz}{relative color distance between 0 and 100 to be considered similar.}

\item{diffpath}{path where to save an image which shows the differences between \code{current} and \code{target}. \code{NULL} means that the diff image is not saved.}
}
\value{
A \code{tinytest} object. A \code{tinytest} object is a \code{logical} with attributes holding information about the test that was run
}
\description{
Test if two image files are equivalent
}
