% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_reg.R
\name{inline_reg}
\alias{inline_reg}
\alias{inline_reg_p}
\alias{inline_anova}
\title{Report the fit of a regression model inline}
\usage{
inline_reg(model, fit = TRUE, stat = TRUE, pval = TRUE, digits = 2)

inline_reg_p(model, digits = 2)

inline_anova(model, stat = TRUE, pval = TRUE, digits = 2)
}
\arguments{
\item{model}{A regression model}

\item{fit}{Logical, whether the regression fit is to be reported (default TRUE, only applicable to \code{lm} objects)}

\item{stat}{Logical, whether the test statistic for the coefficient should be reported (default TRUE)}

\item{pval}{Logical, whether the p-value for the coefficient should be reported (default TRUE)}

\item{digits}{Number of digits to round to (default to 2)}
}
\value{
Returns a LaTeX-formatted result for use in RMarkdown document.
}
\description{
\code{inline_reg} presents the fit of a coefficient from a \code{lm} or \code{glm} model in LaTeX format to be reported inline in an RMarkdown document.
}
\details{
For \code{lm} objects, results include R-squared, the F statistic, and the p-value. For \code{glm} objects, results include the chi-squared statistic and the p-value.

This function currently only supports \code{lm} and \code{glm} objects. Suggestions and requests are welcomed.

\code{inline_reg_p} is a wrapper for \code{inline_reg} to report only the p-value (sets all non-p-value logicals to FALSE). \code{inline_anova} is a wrapper to report a one-way ANOVA result in which \code{fit} is set to FALSE and other logical inputs (\code{stat}, \code{pval}, and \code{digits}) are allowed to be user-defined.
}
\examples{
x1 = rnorm(20)
y1 = x1 + rnorm(20)
model1 = lm(y1 ~ x1)
inline_reg(model1)

x2 = rnorm(20)
y2 = rbinom(n=20, size=1, prob=pnorm(x2))
model2 = glm(y2 ~ x2, family=binomial('logit'))
inline_reg(model2)

}
