% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-proxy.R
\name{calendar_proxy}
\alias{calendar_proxy}
\title{Proxy for calendar htmlwidget}
\usage{
calendar_proxy(shinyId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{shinyId}{single-element character vector indicating the output ID of the
chart to modify (if invoked from a Shiny module, the namespace will be added
automatically).}

\item{session}{the Shiny session object to which the chart belongs; usually the
default value will suffice.}
}
\value{
A \code{calendar_proxy} object.
}
\description{
Proxy for calendar htmlwidget
}
\examples{
\dontrun{

# Consider having created a calendar widget with
calendarOutput("my_calendar") # UI
output$my_calendar <- renderCalendar({}) # Server

# Then you can call proxy methods in observer:

# set calendar proxy then call a cal_proxy_* function
calendar_proxy("my_calendar") \%>\%
  cal_proxy_today()

# or directly
cal_proxy_today("my_calendar")

}
}
\seealso{
Other calendar proxy methods: 
\code{\link{cal_proxy_clear}()},
\code{\link{cal_proxy_clear_selection}()},
\code{\link{cal_proxy_options}()},
\code{\link{cal_proxy_toggle}()},
\code{\link{cal_proxy_view}()},
\code{\link{calendar-proxy-navigate}},
\code{\link{calendar-proxy-schedule}}
}
\concept{calendar proxy methods}
