% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-filters.R
\name{grid_filters}
\alias{grid_filters}
\title{Set filters options}
\usage{
grid_filters(
  grid,
  columns,
  showApplyBtn = NULL,
  showClearBtn = NULL,
  operator = NULL,
  format = "yyyy-MM-dd",
  type = "auto"
)
}
\arguments{
\item{grid}{A table created with \code{\link[=datagrid]{datagrid()}}.}

\item{columns}{Name(s) of column in the data used in \code{\link[=datagrid]{datagrid()}}.}

\item{showApplyBtn}{Apply filters only when button is pressed.}

\item{showClearBtn}{Reset the filter that has already been applied.}

\item{operator}{Multi-option filter, the operator used against multiple rules : \code{"OR"} or \code{"AND"}.}

\item{format}{Date format.}

\item{type}{Type of filter : \code{"auto"}, \code{"text"}, \code{"number"}, \code{"date"} or \code{"select"}.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Set filters options
}
\examples{
library(toastui)

data <- data.frame(
  number = 1:12,
  month.abb = month.abb,
  month.name = month.name,
  date = Sys.Date() + 0:11,
  stringsAsFactors = FALSE
)

datagrid(data) \%>\%
  grid_filters(
    columns = "month.abb",
    showApplyBtn = TRUE,
    showClearBtn = TRUE,
    type = "text"
  ) \%>\%
  grid_filters(
    columns = "month.name",
    type = "select"
  ) \%>\%
  grid_filters(columns = "date") \%>\%
  grid_filters(columns = "number")


# Filter all variables
datagrid(rolling_stones_500) \%>\%
  grid_filters(columns = names(rolling_stones_500))
# or
datagrid(rolling_stones_500, filters = TRUE)
}
