% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{Data}
\alias{Data}
\title{Wheat APSIM model simulated database}
\format{
A dataframe with 640 observations on the following 8 variables.
\itemize{
\item{\code{Yield}}{       unit: kg*ha^-1.}
\item{\code{Genotype}}{    genotypes, 5 varieties.}
\item{\code{Environment}}{ 128 unique combination of environments for each genotype.}
\item{\code{Year}}{        4 years.}
\item{\code{Sites}}{      4 locations.}
\item{\code{Nitrogen}}{    2 nitrogen application levels.}
\item{\code{CO2}}{         2 CO2 concentration levels.}
\item{\code{Sowing}}{      2 sowing dates.}
 }
}
\usage{
data(Data)
}
\description{
Multi-environment trail evaluating 5 genotypes in 4 locations for 4 years, with 2 nitrogen application rates, 2 sowing dates, and 2 CO2 levels of treatments (Casadebaig et al., 2016).
}
\examples{
data(Data)
\donttest{
ggplot2::ggplot(Data,ggplot2::aes(x=Sites,y=Yield,col=Genotype))+
  ggplot2::geom_boxplot()+
  ggplot2::facet_grid(Sowing~Nitrogen,labeller =ggplot2::label_both)+
  ggplot2::ylab(bquote('Wheat yield (ton' \%.\%'ha'^'-1'*')'))
}
}
\references{
\insertRef{casadebaig2016}{toolStability}
}
\keyword{datasets}
