% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficient_of_regression.R
\name{coefficient_of_regression}
\alias{coefficient_of_regression}
\title{Coefficient of regression}
\usage{
coefficient_of_regression(data, trait, genotype, environment)
}
\arguments{
\item{data}{a dataframe containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analysized.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties}

\item{environment}{colname of a column containing a character or factor vector labeling different environments}
}
\value{
a data table with coefficient of regression
}
\description{
\code{coefficient_of_regression} calculate variance of a genotype across environments.
}
\details{
Coefficient of regression (Finlay and Wilkinson, 1963) is calculatd based on regression function.
Variety with low coefficient of regression is considered as stable.
Under the linear model
\deqn{Y =\mu + b_{i}e_{j} + g_{i} + d_{ij}}
where Y is the predicted phenotypic values, \eqn{g_{i}}, \eqn{e_{j}} and \eqn{\mu} denoting
genotypic, environmental and overall population mean,respectively.

The effect of GE-interaction may be expressed as:
\deqn{(ge)_{ij} = b_{i}e_{j} + d_{ij}}
where \eqn{b_{i}} is the coefficient of regression and \eqn{d_{ij}} a deviation.

Coefficient of regression may be expressed as:
\deqn{ b_{i}=1 + \frac{\sum_{j} (X_{ij} -\bar{X_{i.}}-\bar{X_{.j}}+\bar{X_{..}})\cdot
(\bar{X_{.j}}- \bar{X_{..}})}{\sum_{j}(\bar{X_{.j}}-\bar{X_{..}})^{2}}}

where \eqn{X_{ij}} is the observed phenotypic mean value of genotype i(i=1,..., G)
in environment j(j=1,...,E), with \eqn{\bar{X_{i.}}} and  \eqn{\bar{X_{.j}}} \cr
denoting marginal means of genotype i and environment j,respectively. \cr
\eqn{\bar{X_{..}}} denote the overall mean of X.
}
\examples{
data(Data)
coefficient.of.regression <- coefficient_of_regression(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 environment = "Environment")
}
\references{
\insertRef{finlay1963}{toolStability}
}
\author{
Tien Cheng Wang
}
\keyword{approach}
\keyword{regression}
