% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R,
%   R/algorithm_comparison_helpers.R, R/core.R, R/data_preprocessing.R,
%   R/diagnostics.R, R/error_metrics.R, R/experiments.R, R/procrustes.R,
%   R/topolow-package.R, R/transformations.R, R/utils.R, R/visualization.R
\docType{package}
\name{topolow-package}
\alias{topolow-package}
\title{Latin Hypercube and Adaptive Monte Carlo Sampling Functions}
\description{
This file contains functions for performing Latin Hypercube and adaptive Monte Carlo
sampling in parameter space. The AMC sampling adapts based on previous evaluations to focus
sampling in high-likelihood regions. The functions run locally using parallel processing.

Functions handle:
\itemize{
\item A suite of functions to get an initial estimate of the likelihood space through LHS
\item Core adaptive sampling algorithm
\item Likelihood calculations with cross-validation
\item Distribution updating and resampling
\item Safe evaluation wrappers
}

Helper functions for running RACMACS and Topolow during algorithm comparisons.

Core implementations of the TopoLow algorithm for mapping distances in high dimensions.
This file contains the main optimization functions and their variants.

Functions for standardizing and preprocessing antigenic assay data from various
sources into consistent formats. Handles titer and IC50 measurements, threshold
values, and produces both long and matrix formats suitable for mapping.

This file contains functions for assessing model convergence, analyzing chains,
and performing diagnostic tests. Functions are designed to be general-purpose
and usable with any iterative optimization or sampling procedure.

Functions handle:
\itemize{
\item Convergence testing
\item Chain analysis
\item Statistical diagnostics
\item Parameter distribution analysis
}

This file contains functions for calculating error metrics and validation statistics
between predicted and true distance matrices. Functions handle missing values and
special cases like threshold measurements.

Functions for running parameter optimization, comparison experiments,
and other computational experiments.

Functions for comparing different map configurations using Procrustes analysis.
These functions help assess:
\itemize{
\item Statistical significance of differences between maps
\item Quantitative measures of map differences
\item Stability of mapping solutions
}

An implementation of the TopoLow algorithm for antigenic cartography mapping and analysis.
The package provides tools for optimizing point configurations in high-dimensional spaces,
handling missing and thresholded measurements, processing antigenic assay data, and
visualizing antigenic maps.

This file contains functions for transforming data between different formats
used in antigenic cartography. Functions handle conversion between:
\itemize{
\item Long and matrix formats
\item Distance and titer measurements
\item Handling of threshold measurements (< and >)
}

This file contains utility functions used throughout the topolow package.
Functions include data manipulation, and format conversion.

This file contains functions for visualizing topolow results including
dimension reduction plots and cluster visualizations. Supports multiple
plotting methods and customization options.

Functions handle:
\itemize{
\item Temporal mapping visualizations
\item Cluster mapping visualizations
\item 2D and 3D projections
\item Multiple dimension reduction methods
\item Interactive and static plots
\item Diagnostic visualizations
\item Monte Carlo analysis visualizations
}
}
\details{
The package implements a physics-inspired approach combining spring forces and repulsive
interactions to find optimal point configurations. Key features include:
\itemize{
\item Optimization of point configurations in high-dimensional spaces
\item Handling of missing and thresholded measurements
\item Processing of antigenic assay data
\item Interactive visualization of antigenic maps
\item Cross-validation and error analysis
\item Network structure analysis
\item Support for parallel processing
}
}
\section{Main Functions}{

\itemize{
\item \code{\link{create_topolow_map}}: Core optimization algorithm
\item \code{\link{process_antigenic_data}}: Process raw antigenic data
\item \code{\link{initial_parameter_optimization}}: Optimize algorithm parameters
\item \code{\link{plot_temporal_mapping}}: Create temporal visualizations
\item \code{\link{plot_cluster_mapping}}: Create cluster-based visualizations
}
}

\section{Output Files}{

Functions that generate output files (like parameter optimization results) will
create subdirectories in either:
\itemize{
\item The current working directory (if output_dir = NULL)
\item A user-specified directory (via output_dir parameter)
}

The following subdirectories may be created:
\itemize{
\item model_parameters/: Contains optimization results and parameter evaluations
\item init_param_optimization/: Contains files and outputs when using initial_parameter_optimization
}
}

\section{Citation}{

If you use this package, please cite:
Omid Arhami, Pejman Rohani,
Topolow: A mapping algorithm for antigenic cross-reactivity and binding affinity assays,
Bioinformatics, 2025;, btaf372,
https://doi.org/10.1093/bioinformatics/btaf372
\doi{10.1093/bioinformatics/btaf372}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/omid-arhami/topolow}
  \item Report bugs at \url{https://github.com/omid-arhami/topolow/issues}
}

}
\author{
\strong{Maintainer}: Omid Arhami \email{omid.arhami@uga.edu} (\href{https://orcid.org/0009-0005-2681-6598}{ORCID}) [copyright holder]

}
\keyword{internal}
