% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaldi.R
\name{kaldi_resample_waveform}
\alias{kaldi_resample_waveform}
\title{Kaldi's Resample Waveform}
\usage{
kaldi_resample_waveform(
  waveform,
  orig_freq,
  new_freq,
  lowpass_filter_width = 6
)
}
\arguments{
\item{waveform}{(Tensor): The input signal of size (c, n)}

\item{orig_freq}{(float): The original frequency of the signal}

\item{new_freq}{(float): The desired frequency}

\item{lowpass_filter_width}{(int, optional): Controls the sharpness of the filter, more == sharper
but less efficient. We suggest around 4 to 10 for normal use.  (Default: \code{6})}
}
\value{
Tensor: The waveform at the new frequency
}
\description{
Resamples the waveform at the new frequency.
}
\details{
This matches Kaldi's OfflineFeatureTpl ResampleWaveform
which uses a LinearResample (resample a signal at linearly spaced intervals to upsample/downsample
a signal). LinearResample (LR) means that the output signal is at linearly spaced intervals (i.e
the output signal has a frequency of \code{new_freq}). It uses sinc/bandlimited interpolation to
upsample/downsample the signal.
}
\references{
\itemize{
\item \url{https://ccrma.stanford.edu/~jos/resample/Theory_Ideal_Bandlimited_Interpolation.html}
\item \url{https://github.com/kaldi-asr/kaldi/blob/master/src/feat/resample.h#L56}
}
}
