% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWiki.R
\name{readWiki}
\alias{readWiki}
\title{Read Pages from Wikipedia}
\usage{
readWiki(
  category,
  subcategories = TRUE,
  language = "en",
  project = "wikipedia"
)
}
\arguments{
\item{category}{\code{character} articles of which category should be
downloaded, see \code{\link{pages_in_category}}, argument \code{categories}}

\item{subcategories}{\code{logical} (default: \code{TRUE}) should
subcategories be downloaded as well}

\item{language}{\code{character} (default: \code{"en"}),
see \code{\link{pages_in_category}}}

\item{project}{\code{character} (default: \code{"wikipedia"}),
see \code{\link{pages_in_category}}}
}
\value{
\code{\link{textmeta}} object
}
\description{
Downloads pages from Wikipedia and extracts some meta information
with functions from the package \code{\link{WikipediR}}. Creates a
\code{\link{textmeta}} object including the requested pages.
}
\examples{
\donttest{corpus <- readWiki(category="Person_(Studentenbewegung)",
subcategories = FALSE, language = "de", project = "wikipedia")}
}
\keyword{manip}
