% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_gnls_funcs.R
\name{hill_curve}
\alias{hill_curve}
\title{Hill Curve.}
\usage{
hill_curve(hill_tp, hill_ga, hill_gw, lconc)
}
\arguments{
\item{hill_tp}{Numeric, hill top parameter.}

\item{hill_ga}{Numeric, hill AC50 parameter.}

\item{hill_gw}{Numeric, hill coefficient parameter.}

\item{lconc}{Numeric, concentration (in log uM) to calculate the response.}
}
\value{
y Numeric, the calculated response value at lconc.
}
\description{
\code{hill_curve} is used calculate response values given hill parameters.
}
\details{
Given input values for the hill parameters and a concentration, this function
returns the response value at the given concentration. Used to plot the hill
equation resulting from a given fit.
}
\examples{
hill_curve(hill_tp = 100, hill_ga = 0.5, hill_gw = 1, lconc = 0)
}
