% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_functions.R
\name{extract_alleles}
\alias{extract_alleles}
\title{Extract Modal Peaks}
\usage{
extract_alleles(fragments_list)
}
\arguments{
\item{fragments_list}{A list of fragments_repeats objects containing fragment data.}
}
\value{
A dataframe containing modal peak information for each sample
}
\description{
Extracts modal peak information from each sample in a list of fragments.
}
\examples{
gm_raw <- trace::example_data

test_fragments <- peak_table_to_fragments(gm_raw,
  data_format = "genemapper5",
  dye_channel = "B",
  min_size_bp = 400
)

find_alleles(
  fragments_list = test_fragments,
  peak_region_size_gap_threshold = 6,
  peak_region_signal_threshold_multiplier = 1
)

extract_alleles(test_fragments)

}
