% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/PlotWrapper.R
\docType{methods}
\name{saveBasicPlot}
\alias{saveBasicPlot}
\alias{saveBasicPlot,PlotFeatureSet-method}
\title{Save the plot object owned by an object of class/superclass
    PlotFeatureSet as an image.}
\usage{
saveBasicPlot(object, filename, ...)

\S4method{saveBasicPlot}{PlotFeatureSet}(object, filename, type = c("png",
  "jpeg", "jpg", "tiff", "tif", "bmp"), width = 7, height = 7, dpi = 300)
}
\arguments{
\item{object}{An object of (super)class PlotFeatureSet or plot
object of class ggplot or trellis.}

\item{filename}{The full filename, including path, where the plot
should be saved.}

\item{...}{Other named arguments passed on to the class-specific
save method.}

\item{type}{The type of image to save. Default is "png"; should be
one of "jpeg", "jpg", "tiff", "tif", "png", or "bmp". In future
versions, this should be automatically determined from the
filename.}

\item{width}{Width of output, in inches}

\item{height}{Height of output, in inches}

\item{dpi}{Resolution of output, in pixels per inch}
}
\value{
A boolean indicating success of the save operation.
}
\description{
Save a plot to an image file as part of the record
    process. This generally shouldn't need to be overwritten.
}
\section{Methods (by class)}{
\itemize{
\item \code{PlotFeatureSet}: Save the plot object owned by an object of class/superclass PlotFeatureSet as an image.
}}

