% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ots_read_from_api.R
\name{ots_read_from_api}
\alias{ots_read_from_api}
\title{Reads data from the API (internal function)}
\usage{
ots_read_from_api(year = NULL, reporter = NULL, partner = NULL,
  product_code = "all", product_code_length = 4, table = "yrpc",
  max_attempts = 5, use_localhost = FALSE)
}
\arguments{
\item{year}{Year contained within the years specified in
api.tradestatistics.io/year_range (e.g. \code{1980}).
Default set to \code{NULL}.}

\item{reporter}{ISO code for reporter country (e.g. \code{"chl"}). Default set to \code{NULL}.}

\item{partner}{ISO code for partner country (e.g. \code{"chl"}). Default set to \code{NULL}.}

\item{product_code}{HS code (e.g. \code{0101} or \code{01}) to filter products.
Default set to \code{"all"}.}

\item{product_code_length}{Integer to indicate the granularity level on products.
Default set to \code{4}.}

\item{table}{Character string to select the table to obtain the data. Default set to \code{yrpc}
(Year - Reporter - Partner - product).}

\item{max_attempts}{Number of attempts to retry in case of data retrieving failure.
Default set to \code{5}.}

\item{use_localhost}{Logical to determine if the base URL shall be localhost instead
of api.tradestatistics.io. Default set to \code{FALSE}.}
}
\description{
This function accesses \code{api.tradestatistics.io} and
performs different API calls to return \code{data.frames} by reading \code{JSON} data
}
\examples{
\dontrun{
# The next examples can take more than 5 seconds to compute,
# so these are shown without evaluation according to CRAN rules

# Run `countries` to display the full table of countries

# What does Chile export to China? (1980)
ots_read_from_api(year = 1980, reporter = "chl", partner = "chn")

# What can we say about chilean Horses export? (1980)
ots_read_from_api(year = 1980, product_code = "0101", table = "yc")
ots_read_from_api(year = 1980, reporter = "chl", product_code = "0101", table = "yrc")
ots_read_from_api(
  year = 1980, reporter = "chl", partner = "arg", product_code = "0101",
  table = "yrpc"
)
}
}
\keyword{internal}
