% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_turn.R
\name{track_turn}
\alias{track_turn}
\title{Track turn angle}
\usage{
track_turn(x, y)
}
\arguments{
\item{x}{longitude}

\item{y}{latitude}
}
\value{
a numeric vector of absolute turn angles, in degrees
}
\description{
Calculate relative track turning angle on longitude, latitude input vectors.
}
\details{
By convention the last value is set to \code{NA} missing value, because the angle
applies to the relative turn from the current location.

To use this on multiple track ids, use a grouped data frame with tidyverse code like
\code{data \%>\% group_by(id) \%>\% mutate(turn = track_turn(lon, lat))}.

The maximum possible value is 180 degrees and the minimum is -180, although these particular
values are a special case and will probably always be positive. Turn angle is a signed
quantity with negative values for a left turn and positive values for a right turn.
}
\examples{
track_turn(trips0$x, trips0$y)[1:10]

## maximum turn angle
track_turn(c(0, 0, 0), c(0, 1, 0))
## minimum turn angle
track_turn(c(0, 0, 0), c(0, 1, 2))
}
