% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.tramME}
\alias{simulate.tramME}
\title{Simulate from a tramME model}
\usage{
\method{simulate}{tramME}(
  object,
  nsim = 1,
  seed = NULL,
  newdata = model.frame(object),
  ranef = NULL,
  what = c("response", "ranef", "joint"),
  bysim = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted tramME object.}

\item{nsim}{number of samples to generate}

\item{seed}{optional seed for the random number generator}

\item{newdata}{an optional data frame of observations}

\item{ranef}{If \code{NULL}, random effects are simulated from their estimated
distribution for each of the \code{nsim} draws, i.e. the simulation is from the
marginal/joint distribution of the response (and random effects).
Otherwise the simulation is conditional on the supplied random effects.
When \code{ranef = "zero"}, a vector of zeros with the right size is
substituted.}

\item{what}{Defaults to \code{"response"}. \code{what = "ranef"} returns draws from
the random effects distribution, \code{what = "joint"} results in simulated data
from the joint distribution of random effects and responses. When it is
set to other than 'response', \code{ranef=NULL} and \code{bysim=TRUE} must
be set.}

\item{bysim}{logical, if \code{TRUE} a list with \code{nsim} elements is returned,
               each element is of length \code{nrow(newdata)} and 
               contains one sample from the conditional distribution for each
               row of \code{newdata}. If \code{FALSE}, a list of length \code{nrow(newdata)}
               is returned, its ith element of length \code{nsim} contains \code{nsim} samples
               from the conditional distribution given \code{newdata[i,]}.}

\item{...}{Additional arguments, passed to \code{\link[mlt]{simulate.mlt}}.}
}
\value{
A \code{simulate.tramME} object with the structure defined by the inputs.
}
\description{
Utilizes the simulation method of mlt. When the vector of random effects is supplied, the
simulation is conditional on it.
}
\details{
In certain settings, the conditional CDF of the outcome cannot be inverted on some
some intervals. In these cases, \code{simulate.mlt} returns censored observations.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
sim <- simulate(fit, nsim = 10, seed = 123)
}
