% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_filter_fast_proto.R
\name{time_filter_fast_proto}
\alias{time_filter_fast_proto}
\title{Time Filter (Fast) with Protobuf}
\usage{
time_filter_fast_proto(
  departureLat,
  departureLng,
  country = c("uk", "ireland"),
  travelTime,
  destinationCoordinates,
  transportation = names(protoTransport),
  useDistance = FALSE
)
}
\arguments{
\item{departureLat}{origin latitude}

\item{departureLng}{origin longitude}

\item{country}{Origin country. Only UK and Ireland are supported.}

\item{travelTime}{Maximum journey time (in seconds).}

\item{destinationCoordinates}{data.frame with pairs of coordinates. Coordinates columns must be named 'lat' and 'lng'}

\item{transportation}{One of supported transportation methods: 'pt', 'driving+ferry', 'cycling+ferry', 'walking+ferry'.}

\item{useDistance}{return distance information}
}
\value{
API response parsed as a list and as a raw json
}
\description{
The Travel Time Matrix (Fast) endpoint is available with even higher performance through a
version using Protocol Buffers.
The endpoint takes as inputs a single origin location, multiple destination locations, a mode of transport,
and a maximum travel time.
The endpoint returns the travel times to each destination location, so long as it is within the maximum travel time.
}
\details{
See \url{https://docs.traveltime.com/api/start/travel-time-distance-matrix-proto} for details
}
\examples{
\dontrun{
time_filter_fast_proto(
departureLat = 51.508930,
departureLng = -0.131387,
destinationCoordinates = data.frame(
  lat = c(51.508824, 51.536067),
  lng = c(-0.167093, -0.153596)
),
transportation = 'driving+ferry',
travelTime = 7200,
country = "uk",
useDistance = FALSE
)
}
}
