% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitTrawlFunctions.R
\name{fit_DExptrawl}
\alias{fit_DExptrawl}
\title{Fits the trawl function consisting of the weighted sum of two exponential functions}
\usage{
fit_DExptrawl(x, Delta = 1, GMMlag = 5, plotacf = FALSE,
  lags = 100)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{Delta}{interval length of the time grid used in the time series, the
default is 1}

\item{GMMlag}{lag length used in the GMM estimation, the default is 5}

\item{plotacf}{binary variable specifying whether or not the empirical and
fitted autocorrelation function should be plotted}

\item{lags}{number of lags to be used in the plot of the autocorrelation
function}
}
\value{
w: the weight parameter (restricted to be in [0,0.5] for
 identifiability reasons)

lambda1: the first memory parameter (denoted by \eqn{\lambda_1} above)

lambda2: the second memory parameter (denoted by \eqn{\lambda_2}
 above)

LM: The Lebesgue measure of the trawl set associated with the double
 exponential trawl
}
\description{
Fits the trawl function consisting of the weighted sum of two exponential functions
}
\details{
The trawl function is parametrised by the three parameters \eqn{0\leq
 w \leq 1} and \eqn{\lambda_1,\lambda_2 > 0} as follows: \deqn{g(x) =
 we^{\lambda_1 x}+(1-w)e^{\lambda_2 x},  \mbox{ for }  x \le 0.} The Lebesgue measure
 of the corresponding trawl set is given by
 \eqn{w/\lambda_1+(1-w)/\lambda_2}.
}
\examples{
\donttest{
#Simulate a univariate trawl process and fit the double exponential trawl
#function
set.seed(1)
t <- 1000
Delta <- 1
v <- 250
w <- 0.1
lambda1 <- 0.1
lambda2 <- 1
#Simulate a univariate trawl process with double exponential trawl function
#and Poisson marginal law
trawl <- sim_UnivariateTrawl(t,Delta,burnin=50,marginal =c("Poi"),trawl
="DExp",v=v, w=w,lambda1=lambda1,lambda2=lambda2)
#Fit the double exponential trawl function to the simulated data
fittrawlfct <- fit_DExptrawl(trawl,Delta, plotacf=TRUE,lags=500)
#Print the results
print(paste("w: estimated:", fittrawlfct$w, ", theoretical:", w))
print(paste("lambda1: estimated:", fittrawlfct$lambda1, ", theoretical:",
lambda1))
print(paste("lambda2: estimated:", fittrawlfct$lambda2, ", theoretical:",
lambda2))
}
}
