% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitTrawlFunctions.R
\name{fit_LMtrawl}
\alias{fit_LMtrawl}
\title{Fits a long memory trawl function to equidistant univariate time series data}
\usage{
fit_LMtrawl(x, Delta = 1, GMMlag = 5, plotacf = FALSE, lags = 100)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{Delta}{interval length of the time grid used in the time series, the
default is 1}

\item{GMMlag}{lag length used in the GMM estimation, the default is 5}

\item{plotacf}{binary variable specifying whether or not the empirical and
fitted autocorrelation function should be plotted}

\item{lags}{number of lags to be used in the plot of the autocorrelation
function}
}
\value{
alpha: parameter in the long memory trawl

H: parameter in the long memory trawl

LM: The Lebesgue measure of the trawl set associated with the
long memory  trawl
}
\description{
Fits a long memory trawl function to equidistant univariate time series data
}
\details{
The trawl function is parametrised by the two parameters \eqn{H> 1}
 and \eqn{\alpha > 0} as follows: \deqn{g(x) = (1-x/\alpha)^{-H},\mbox{ for }
 x \le  0.} The Lebesgue measure of the corresponding trawl set is given by
 \eqn{\alpha/(1-H)}.
}
\examples{
\donttest{
#Simulate a univariate trawl process and fit the long memory trawl function
set.seed(1)
t <- 1000
Delta <- 1
v <- 250
alpha <- 0.01
H <- 1.3
#Simulate a univariate trawl process with LM trawl function and Poisson
#marginal law
trawl <- sim_UnivariateTrawl(t,Delta,burnin=50,marginal =c("Poi"),trawl
="LM",v=v, alpha=alpha, H=H)
#Fit the LM trawl function to the simulated data
fittrawlfct <- fit_LMtrawl(trawl,Delta, plotacf=TRUE,lags=500)
#Print the results
print(paste("alpha: estimated:", fittrawlfct$alpha, ", theoretical:", alpha))
print(paste("H: estimated:", fittrawlfct$H, ", theoretical:", H))
}
}
