% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_genetree_summary_stat.R
\name{count_cherries}
\alias{count_cherries}
\title{Calculate cherry statistic for gene-trees}
\usage{
count_cherries(tree)
}
\arguments{
\item{tree}{an object of class "phylo"}
}
\value{
The value fo cherries on a tree
}
\description{
Calculate cherry statistic according to the definition given in  McKenzie and Steel 2000 (see below for reference)
}
\details{
This calculates the value for the cherry test statistic on a rooted tree. Note that this does not perform the actual
hypothesis test against Yule or uniform tree models.
}
\examples{
# first simulate a species tree
mu <- 0.5
lambda <- 1.0
nt <- 6
tr <- sim_stBD(sbr = lambda, sdr = mu, numbsim = 1, n_tips = nt)
treeducken::count_cherries(tr[[1]])
# to do the hypothesis test you can use the ape version of this function
ape::cherry(tr[[1]])
}
\references{
McKenzie, A. and Steel, M. (2000) Distributions of cherries for two models of trees. Mathematical Biosciences, 164, 81–92.
}
\author{
Emmanuel Paradis
}
