% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treescape.R
\name{treescape}
\alias{treescape}
\title{Phylogenetic tree exploration}
\usage{
treescape(x, method = "treeVec", nf = NULL, return.tree.vectors = FALSE,
  ...)
}
\arguments{
\item{x}{an object of the class multiPhylo}

\item{method}{the method for summarising the tree as a vector. 
Choose from: 
\code{treeVec} (default) the Kendall Colijn metric vector. 
The others are inherited from \code{distTips} in \code{adephylo}:
\code{patristic}: for each pair of tips, the sum of branch lengths on the path between them
\code{nNodes}: for each pair of tips, the number of nodes on the path between them
\code{Abouheif}: performs Abouheif's test. See Pavoine et al. (2008) and \code{adephylo}.
\code{sumDD}: sum of direct descendants of all nodes on the path, related to Abouheif's test. See \code{adephylo}.}

\item{nf}{the number of principal components to retain}

\item{return.tree.vectors}{option to also return the tree vectors. Note that this can use a lot of memory so defaults to \code{FALSE}.}

\item{...}{further arguments to be passed to \code{method}.}
}
\description{
Compares phylogenetic trees and maps them into a small number of dimensions for easy visualisation and identification of clusters.
}
\examples{

## generate list of trees
x <- rmtree(10, 20)
names(x) <- paste("tree", 1:10, sep = "")

## use treescape
res <- treescape(x, nf=3)
table.paint(as.matrix(res$D))
scatter(res$pco)

data(woodmiceTrees)
woodmiceDists <- treescape(woodmiceTrees,nf=3)
plot(woodmiceDists$pco$li[,1],woodmiceDists$pco$li[,2])
woodmicedf <- woodmiceDists$pco$li
if(require(ggplot2)){
woodmiceplot <- ggplot(woodmicedf, aes(x=A1, y=A2)) # create plot
woodmiceplot + geom_density2d(colour="gray80") + # contour lines
geom_point(size=6, shape=1, colour="gray50") + # grey edges
geom_point(size=6, alpha=0.2, colour="navy") + # transparent blue points
xlab("") + ylab("") + theme_bw(base_family="") # remove axis labels and grey background
}
\dontrun{
if(require(rgl)){
plot3d(woodmicedf[,1], woodmicedf[,2], woodmicedf[,3], type="s", size=1.5,
col="navy", alpha=0.5, xlab="", ylab="", zlab="")
}
}

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

