% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{language_symbol_for_name}
\alias{language_symbol_for_name}
\title{Language symbols}
\usage{
language_symbol_for_name(x, name, ..., named = TRUE)
}
\arguments{
\item{x}{\verb{[tree_sitter_language]}

A tree-sitter language object.}

\item{name}{\verb{[character]}

The names to look up symbols for.}

\item{...}{These dots are for future extensions and must be empty.}

\item{named}{\verb{[logical]}

Should named or anonymous nodes be looked up? Recycled to the
size of \code{name}.}
}
\value{
An integer vector the same size as \code{name} containing either:
\itemize{
\item The integer symbol ID of the node name, if known.
\item \code{NA} if the node name was not known.
}
}
\description{
Get the integer symbol ID for a particular node name. Can be useful
for exploring the grammar.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
language_symbol_for_name(language, "identifier")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=language_symbol_name]{language_symbol_name()}}
}
