% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sea.sens.slope.R
\name{sea.sens.slope}
\alias{sea.sens.slope}
\title{Seasonal Sen's Slope}
\usage{
sea.sens.slope(x)
}
\arguments{
\item{x}{a time series object of class "ts"}
}
\value{
numeric, Seasonal Sen's slope.
}
\description{
Computes seasonal Sen's slope  for linear rate of change
}
\details{
Acccording to Hirsch et al. (1982) the seasonal Sen's slope
is calculated as follows:

\deqn{
d_{ijk} = \frac{x_{ij} - x_{ik}}{j - k}
}{%
d[ijk] = (x[ij] - x[ik]) / (j - k)
}

for each \eqn{(x_{ij}, x_{ik})}{(x[ij], x[ik])}
pair \eqn{i = 1, \ldots, m},
where \eqn{(1 \leq k < j \leq n_i} and \eqn{n_i}{n[i]} is
the number of known values in the \eqn{i-th} season.
The seasonal slope estimator is the median of
the \eqn{d_{ijk}}{d[ijk]} values.
}
\note{
Current Version is for complete observations only.
}
\examples{
sea.sens.slope(nottem)

}
\references{
Hipel, K.W. and McLeod, A.I. (2005), \emph{Time Series Modelling of Water
Resources and Environmental Systems}.
\url{http://www.stats.uwo.ca/faculty/aim/1994Book/}.

Hirsch, R., J. Slack, R. Smith (1982), T
echniques of Trend Analysis for Monthly Water Quality Data.
\emph{Water Resources Research} 18, 107-121.

Sen, P.K. (1968), Estimates of the regression coefficient based on
Kendall's tau, \emph{Journal of the American Statistical Association} 63,
1379--1389.
}
\seealso{
\code{\link{smk.test}},
}
\keyword{nonparametric}
\keyword{ts}
\keyword{univar}
