% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs_for_attributes.R
\name{at_mutate}
\alias{at_mutate}
\alias{at_mutate_}
\alias{at_select}
\alias{at_select_}
\alias{at_rename}
\alias{at_rename_}
\alias{at_slice}
\alias{at_slice_}
\title{Manipulate attributes in a dplyr fashion}
\usage{
at_mutate(obj, ...)

at_mutate_(obj, ..., .dots)

at_select(obj, ...)

at_select_(obj, ..., .dots)

at_rename(obj, ...)

at_rename_(obj, ..., .dots)

at_slice(obj, at)

at_slice_(obj, at)
}
\arguments{
\item{obj}{An object.}

\item{...}{Comma separated list of unquoted expressions.}

\item{.dots}{Used to work around non-standard evaluation.}

\item{at}{Attribute to be obtained.}
}
\value{
\code{at_slice} returns the attribute chosen. 
The other functions return \code{obj} with possibly modified attributes.
}
\description{
The function \code{at_mutate} 
adds or changes attributes to \code{obj}. 

The function \code{at_select} 
selects attributes of \code{obj}, and removes the others. 

The function \code{at_rename} 
renames attributes of \code{obj}. 

The function \code{at_slice} 
chooses a specific attribute and returns it.
}
\examples{
library(dplyr)
df <- data.frame(x = sample(10, 5, rep = TRUE),
                 y = sample(10, 5, rep = TRUE)) \%>\%
  at_mutate(example="yes",
            package="dplyr")
tribe(df)

at_slice(df, names)
at_slice_(df, "class")
at_slice_(df, ~ package)

df <- df \%>\%
  at_mutate_(package = ~ NULL,
             example = ~ "no")
tribe(df)

df <- df \%>\% 
  at_mutate_(.dots = list(x =~ 2, y =~ c(3,4)))
tribe(df)

}
\seealso{
\code{\link{structure}}, \code{\link{attributes}}
}
